package gov.va.med.mhv.admin.converter;

import gov.va.med.mhv.admin.dto.UserProfileDeactivationAuditDTO;
import gov.va.med.mhv.admin.model.UserProfileDeactivationAudit;
import gov.va.med.mhv.common.data.converter.UserProfileDeactivationReasonConverter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class UserProfileDeactivationAuditConverter
		implements Converter<UserProfileDeactivationAudit, UserProfileDeactivationAuditDTO> {

	@Autowired
	UserProfileDeactivationReasonConverter userProfileDeactivationReasonConverter;

	@Override
	public UserProfileDeactivationAuditDTO convert(UserProfileDeactivationAudit userProfileDeactivationAudit) {

		UserProfileDeactivationAuditDTO userProfileDeactivationAuditDTO = new UserProfileDeactivationAuditDTO();

		if (userProfileDeactivationAudit != null) {
			userProfileDeactivationAuditDTO.setId(userProfileDeactivationAudit.getId());
			userProfileDeactivationAuditDTO.setDeactivationReason(userProfileDeactivationReasonConverter
					.convert(userProfileDeactivationAudit.getDeactivationReason()));
			userProfileDeactivationAuditDTO.setOplock(userProfileDeactivationAudit.getOplock());
			userProfileDeactivationAuditDTO.setNotes(userProfileDeactivationAudit.getNotes());
			userProfileDeactivationAuditDTO.setChangeDate(userProfileDeactivationAudit.getChangeDate());
		}
		return userProfileDeactivationAuditDTO;
	}

	public List<UserProfileDeactivationAuditDTO> convertList(List<UserProfileDeactivationAudit> source) {

		List<UserProfileDeactivationAuditDTO> destination = new ArrayList<UserProfileDeactivationAuditDTO>();
		for (UserProfileDeactivationAudit a : source) {
			destination.add(convert(a));
		}
		return destination;
	}

}
